
//<HEADER_BEGIN>
//================================================
//File name: uxdvim.h
//Date : January, 15 2002  12:15
//Copyright (c) 2002 - Crystal Decisions Corp.
//================================================
//<HEADER_END>

#if !defined (UXDVIM_H)
#define UXDVIM_H

// Set 1-byte structure alignment
#if defined (__BORLANDC__) // Borland C/C++
  #pragma option -a-
#elif defined (_MSC_VER) // Microsoft Visual C++
  #if _MSC_VER >= 900 // MSVC 2.x and later
    #pragma pack (push)
  #endif
  #pragma pack (1)
#endif

#if defined (__cplusplus)
extern "C"
{
#endif

#define UXDVIMType             0

typedef struct UXDVIMOptionsA
{
    WORD structSize;

    char FAR *toList;
    char FAR *ccList;
    char FAR *bccList;
    char FAR *subject;
    char FAR *message;

	char FAR *userName;
    char FAR *password;

	WORD nEncodedBytes;

#if defined (__cplusplus)
public:
    UXDVIMOptionsA()
    {
        toList  = NULL;
        ccList  = NULL;
        subject = NULL;
        message = NULL;
        bccList = NULL;
		userName = NULL;
        password = NULL;
        nEncodedBytes = 0;
    };
#endif

}
    UXDVIMOptionsA;


typedef struct UXDVIMOptionsW
{
    WORD structSize;

    wchar_t FAR *toList;
    wchar_t FAR *ccList;
    wchar_t FAR *bccList;
    wchar_t FAR *subject;
    wchar_t FAR *message;

	wchar_t FAR *userName;
    wchar_t FAR *password;

	WORD nEncodedBytes;

#if defined (__cplusplus)
public:
    UXDVIMOptionsW()
    {
        toList  = NULL;
        ccList  = NULL;
        subject = NULL;
        message = NULL;
        bccList = NULL;
		userName = NULL;
        password = NULL;
        nEncodedBytes = 0;
    };
#endif


}
    UXDVIMOptionsW;

#ifdef UNICODE
typedef UXDVIMOptionsW UXDVIMOptions;
#else
typedef UXDVIMOptionsA UXDVIMOptions;
#endif  //UNICODE 


#define UXDVIMOptionsSize      (sizeof (UXDVIMOptions))

#if defined (__cplusplus)
}
#endif

#endif 
